//
//  SectionsViewController.m
//  Sections
//
//  Created by Robert Górczyński on 11-06-30.
//

#import "SectionsViewController.h"
#import "NSDictionary-MutableDeepCopy.h"

@implementation SectionsViewController
@synthesize names; 
@synthesize keys;
@synthesize table; 
@synthesize search; 
@synthesize allNames; 

#pragma mark - 
#pragma mark Metody własne 
- (void)resetSearch { 
    NSMutableDictionary *allNamesCopy = [self.allNames mutableDeepCopy]; 
    self.names = allNamesCopy; 
    [allNamesCopy release]; 
    NSMutableArray *keyArray = [[NSMutableArray alloc] init]; 
    [keyArray addObject:UITableViewIndexSearch]; 
    [keyArray addObjectsFromArray:[[self.allNames allKeys] 
								   sortedArrayUsingSelector:@selector(compare:)]]; 
    self.keys = keyArray; 
    [keyArray release]; 
} 

- (void)handleSearchForTerm:(NSString *)searchTerm { 
    NSMutableArray *sectionsToRemove = [[NSMutableArray alloc] init]; 
    [self resetSearch]; 
	
    for (NSString *key in self.keys) { 
        NSMutableArray *array = [names valueForKey:key]; 
        NSMutableArray *toRemove = [[NSMutableArray alloc] init]; 
        for (NSString *name in array) { 
            if ([name rangeOfString:searchTerm 
							options:NSCaseInsensitiveSearch].location == NSNotFound) 
                [toRemove addObject:name]; 
        } 
        if ([array count] == [toRemove count]) 
            [sectionsToRemove addObject:key]; 
		
        [array removeObjectsInArray:toRemove]; 
        [toRemove release]; 
    } 
    [self.keys removeObjectsInArray:sectionsToRemove]; 
    [sectionsToRemove release]; 
    [table reloadData]; 
}


- (void)viewDidLoad { 
    NSString *path = [[NSBundle mainBundle] pathForResource:@"sortednames" 
                                                     ofType:@"plist"]; 
    NSDictionary *dict = [[NSDictionary alloc] 
                          initWithContentsOfFile:path]; 
	self.allNames = dict;  
    [dict release]; 
	
    [self resetSearch]; 
    [table reloadData]; 
    [table setContentOffset:CGPointMake(0.0, 44.0) animated:NO]; 	
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.table = nil; 
    self.search = nil; 
    self.allNames = nil; 	
	self.names = nil; 
    self.keys = nil; 
    [super viewDidUnload]; 
}


- (void)dealloc {
	[table release]; 
    [search release]; 
    [allNames release]; 	
	[names release]; 
    [keys release]; 
    [super dealloc];
}

#pragma mark - 
#pragma mark Metody źródła danych tabeli
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
	return ([keys count] > 0) ? [keys count] : 1;  
} 

- (NSInteger)tableView:(UITableView *)tableView 
 numberOfRowsInSection:(NSInteger)section { 
	if ([keys count] == 0) 
        return 0;
    NSString *key = [keys objectAtIndex:section]; 
    NSArray *nameSection = [names objectForKey:key]; 
    return [nameSection count]; 
} 

- (UITableViewCell *)tableView:(UITableView *)tableView 
		 cellForRowAtIndexPath:(NSIndexPath *)indexPath { 
    NSUInteger section = [indexPath section]; 
    NSUInteger row = [indexPath row]; 
	
    NSString *key = [keys objectAtIndex:section]; 
    NSArray *nameSection = [names objectForKey:key]; 
	
    static NSString *SectionsTableIdentifier = @"SectionsTableIdentifier"; 
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier: 
							 SectionsTableIdentifier]; 
    if (cell == nil) { 
        cell = [[[UITableViewCell alloc] 
				 initWithStyle:UITableViewCellStyleDefault 
				 reuseIdentifier:SectionsTableIdentifier] autorelease]; 
    } 
	
    cell.textLabel.text = [nameSection objectAtIndex:row]; 
    return cell; 
} 

- (NSString *)tableView:(UITableView *)tableView 
titleForHeaderInSection:(NSInteger)section { 
	if ([keys count] == 0) 
        return nil; 
	
    NSString *key = [keys objectAtIndex:section];
	if (key == UITableViewIndexSearch) 
        return nil; 
    return key; 
} 

- (NSArray *)sectionIndexTitlesForTableView:(UITableView *)tableView {
	if (isSearching) 
        return nil; 
    return keys; 
}

#pragma mark - 
#pragma mark Metody delegata tabeli
- (NSIndexPath *)tableView:(UITableView *)tableView 
  willSelectRowAtIndexPath:(NSIndexPath *)indexPath { 
    [search resignFirstResponder];
	isSearching = NO; 
    search.text = @""; 
    [tableView reloadData]; 	
    return indexPath; 
} 

#pragma mark - 
#pragma mark Metody delegata paska wyszukiwania
- (void)searchBarSearchButtonClicked:(UISearchBar *)searchBar { 
    NSString *searchTerm = [searchBar text]; 
    [self handleSearchForTerm:searchTerm]; 
} 

- (void)searchBar:(UISearchBar *)searchBar 
    textDidChange:(NSString *)searchTerm {
    if ([searchTerm length] == 0) { 
        [self resetSearch]; 
        [table reloadData]; 
        return; 
    } 
    [self handleSearchForTerm:searchTerm]; 
} 

- (void)searchBarCancelButtonClicked:(UISearchBar *)searchBar { 
    isSearching = NO; 
	search.text = @""; 
    [self resetSearch]; 
    [table reloadData]; 
    [searchBar resignFirstResponder]; 
} 

- (void)searchBarTextDidBeginEditing:(UISearchBar *)searchBar { 
    isSearching = YES; 
    [table reloadData]; 
}

- (NSInteger)tableView:(UITableView *)tableView 
sectionForSectionIndexTitle:(NSString *)title 
			   atIndex:(NSInteger)index { 
    NSString *key = [keys objectAtIndex:index]; 
    if (key == UITableViewIndexSearch) { 
        [tableView setContentOffset:CGPointZero animated:NO]; 
        return NSNotFound; 
    } 
    else return index; 
}

@end
